using System;
using System.Collections;
using System.ComponentModel;
using System.Drawing;
using System.Data;
using System.Text;

using System.Windows.Forms;
using gov.va.med.vbecs.Common;

namespace gov.va.med.vbecs.GUI
{
	/// <summary>
	/// Class FrmLogInReagents
	/// </summary>
	public class FrmLogInReagents : gov.va.med.vbecs.GUI.VbecsBaseForm
	{
		#region Form Controls
		private System.Windows.Forms.GroupBox grpImage;
		private gov.va.med.vbecs.GUI.controls.VbecsButton btnOK;
		private System.Windows.Forms.Button btnCancel;
		private System.Windows.Forms.GroupBox grpInvoice;
		private System.Windows.Forms.Label lblReceivedDate;
		private System.Windows.Forms.DateTimePicker dtpReceivedDate;
		private System.Windows.Forms.Label lblInvoiceNumber;
		private System.Windows.Forms.TextBox txtInvoiceNumber;
		private System.Windows.Forms.Label lblManufacturer;
		private gov.va.med.vbecs.GUI.controls.ComboBoxLookup cmbManufacturer;
		private System.Windows.Forms.GroupBox grpReagent;
		private System.Windows.Forms.Label lblManufacturerReagentName;
		private System.Windows.Forms.Label lblReagentType;
		private gov.va.med.vbecs.GUI.controls.ComboBoxLookup cmbReagentType;
		private System.Windows.Forms.Label lblLotNumber;
		private System.Windows.Forms.TextBox txtLotNumber;
		private System.Windows.Forms.Label lblExpirationDate;
		private System.Windows.Forms.Label lblVials;
		private gov.va.med.vbecs.GUI.controls.VbecsButton btnAdd;
		private System.Windows.Forms.GroupBox grpInventory;
		private System.Windows.Forms.ListView lvInventory;
		private System.Windows.Forms.ColumnHeader colCheckBox;
		private System.Windows.Forms.ColumnHeader colReagentName;
		private System.Windows.Forms.ColumnHeader colLotNumber;
		private System.Windows.Forms.ColumnHeader colExpirationDate;
		private System.Windows.Forms.ColumnHeader colVials;
		private System.Windows.Forms.ColumnHeader colInvoice;
		private System.Windows.Forms.ColumnHeader colManufacturer;
		private System.Windows.Forms.PictureBox pictureBox1;
		private System.Windows.Forms.Button btnClear;
		private System.Windows.Forms.RadioButton rdoSatisfactory;
		private System.Windows.Forms.RadioButton rdoUnsatisfactory;
		private System.ComponentModel.IContainer components = null;
		private gov.va.med.vbecs.GUI.controls.ComboBoxLookup cmbManufacturerReagentName;
		private System.Windows.Forms.ToolTip toolTip1;
		private System.Windows.Forms.TextBox txtComments;
		private System.Windows.Forms.ColumnHeader colReagentType;
		private System.Windows.Forms.ColumnHeader colInspection;
		private System.Windows.Forms.GroupBox groupBox1;
		private System.Windows.Forms.DateTimePicker dtpExpirationDate;
		private gov.va.med.vbecs.GUI.controls.ComboBoxLookup cmbComment;
		private System.Windows.Forms.Panel pnlComment;
		private System.Windows.Forms.Label lblComment;
		private System.Windows.Forms.Label lblDetails;
		private gov.va.med.vbecs.GUI.controls.VbecsNumericUpDown updVials;

		#endregion

		#region Variables

		private DataTable _dtManufacturers;
		private DataTable _dtReagentTypes;
		private DataTable _dtManufacturerReagentNames;
		private DataTable _dtLvReagents;
		private DataTable _dtCannedComments;
        


        private bool _bValidReceivedDate = true;
		private bool _bValidInvoice = false;
		private bool _bValidManufacturer = false;
		private bool _bValidReagentName = false;
		private bool _bValidReagentType = false;
		private bool _bValidLotNumber = false;
		private bool _bValidExpirationDate = true;
		private bool _bValidVials = false;
		private bool _bValidTests = true;
		private bool _bValidInspection = false;
		private int _nSelectedListViewItemIndex;

		#endregion

		#region Constructors/Dispose

		/// <summary>
		/// Constructor
		/// </summary>
		public FrmLogInReagents()
		{
			// This call is required by the Windows Form Designer.
			InitializeComponent();

			_dtLvReagents = BOL.Reagent.InitializeReagentsAndManufacturersTable();
			SetComponentProperties();
			LoadReagentManufacturers();
			LoadReagentTypes();
			LoadCannedComments();
			this.dtpReceivedDate.Focus();
		}

		/// <summary>
		/// Clean up any resources being used.
		/// </summary>
		protected override void Dispose( bool disposing )
		{
			if( disposing )
			{
				if (components != null) 
				{
					components.Dispose();
				}
			}
			base.Dispose( disposing );
		}

		#endregion

		#region Designer generated code
		/// <summary>
		/// Required method for Designer support - do not modify
		/// the contents of this method with the code editor.
		/// </summary>
		private void InitializeComponent()
		{
			this.components = new System.ComponentModel.Container();
			System.Resources.ResourceManager resources = new System.Resources.ResourceManager(typeof(FrmLogInReagents));
			this.grpImage = new System.Windows.Forms.GroupBox();
			this.pictureBox1 = new System.Windows.Forms.PictureBox();
			this.grpInvoice = new System.Windows.Forms.GroupBox();
			this.cmbManufacturer = new gov.va.med.vbecs.GUI.controls.ComboBoxLookup(this.components);
			this.lblManufacturer = new System.Windows.Forms.Label();
			this.txtInvoiceNumber = new System.Windows.Forms.TextBox();
			this.lblInvoiceNumber = new System.Windows.Forms.Label();
			this.dtpReceivedDate = new System.Windows.Forms.DateTimePicker();
			this.lblReceivedDate = new System.Windows.Forms.Label();
			this.btnOK = new gov.va.med.vbecs.GUI.controls.VbecsButton();
			this.btnCancel = new System.Windows.Forms.Button();
			this.grpReagent = new System.Windows.Forms.GroupBox();
			this.updVials = new gov.va.med.vbecs.GUI.controls.VbecsNumericUpDown();
			this.dtpExpirationDate = new System.Windows.Forms.DateTimePicker();
			this.groupBox1 = new System.Windows.Forms.GroupBox();
			this.pnlComment = new System.Windows.Forms.Panel();
			this.lblDetails = new System.Windows.Forms.Label();
			this.lblComment = new System.Windows.Forms.Label();
			this.txtComments = new System.Windows.Forms.TextBox();
			this.cmbComment = new gov.va.med.vbecs.GUI.controls.ComboBoxLookup(this.components);
			this.rdoSatisfactory = new System.Windows.Forms.RadioButton();
			this.rdoUnsatisfactory = new System.Windows.Forms.RadioButton();
			this.btnClear = new System.Windows.Forms.Button();
			this.cmbManufacturerReagentName = new gov.va.med.vbecs.GUI.controls.ComboBoxLookup(this.components);
			this.btnAdd = new gov.va.med.vbecs.GUI.controls.VbecsButton();
			this.lblVials = new System.Windows.Forms.Label();
			this.lblExpirationDate = new System.Windows.Forms.Label();
			this.txtLotNumber = new System.Windows.Forms.TextBox();
			this.lblLotNumber = new System.Windows.Forms.Label();
			this.cmbReagentType = new gov.va.med.vbecs.GUI.controls.ComboBoxLookup(this.components);
			this.lblReagentType = new System.Windows.Forms.Label();
			this.lblManufacturerReagentName = new System.Windows.Forms.Label();
			this.grpInventory = new System.Windows.Forms.GroupBox();
			this.lvInventory = new System.Windows.Forms.ListView();
			this.colCheckBox = new System.Windows.Forms.ColumnHeader();
			this.colReagentName = new System.Windows.Forms.ColumnHeader();
			this.colLotNumber = new System.Windows.Forms.ColumnHeader();
			this.colExpirationDate = new System.Windows.Forms.ColumnHeader();
			this.colVials = new System.Windows.Forms.ColumnHeader();
			this.colInvoice = new System.Windows.Forms.ColumnHeader();
			this.colManufacturer = new System.Windows.Forms.ColumnHeader();
			this.colReagentType = new System.Windows.Forms.ColumnHeader();
			this.colInspection = new System.Windows.Forms.ColumnHeader();
			this.toolTip1 = new System.Windows.Forms.ToolTip(this.components);
			this.grpImage.SuspendLayout();
			this.grpInvoice.SuspendLayout();
			this.grpReagent.SuspendLayout();
			((System.ComponentModel.ISupportInitialize)(this.updVials)).BeginInit();
			this.groupBox1.SuspendLayout();
			this.pnlComment.SuspendLayout();
			this.grpInventory.SuspendLayout();
			this.SuspendLayout();
			// 
			// vbecsLogo1
			// 
			this.vbecsLogo1.Name = "vbecsLogo1";
			this.vbecsLogo1.Size = new System.Drawing.Size(742, 30);
			this.vbecsLogo1.TabIndex = 5;
			// 
			// lblRequiredField
			// 
			this.lblRequiredField.Location = new System.Drawing.Point(0, 507);
			this.lblRequiredField.Name = "lblRequiredField";
			this.lblRequiredField.TabIndex = 7;
			// 
			// grpImage
			// 
			this.grpImage.Anchor = ((System.Windows.Forms.AnchorStyles)(((System.Windows.Forms.AnchorStyles.Top | System.Windows.Forms.AnchorStyles.Bottom) 
				| System.Windows.Forms.AnchorStyles.Left)));
			this.grpImage.Controls.Add(this.pictureBox1);
			this.grpImage.Location = new System.Drawing.Point(4, 36);
			this.grpImage.Name = "grpImage";
			this.grpImage.Size = new System.Drawing.Size(52, 452);
			this.grpImage.TabIndex = 6;
			this.grpImage.TabStop = false;
			// 
			// pictureBox1
			// 
			this.pictureBox1.Image = ((System.Drawing.Image)(resources.GetObject("pictureBox1.Image")));
			this.pictureBox1.Location = new System.Drawing.Point(4, 12);
			this.pictureBox1.Name = "pictureBox1";
			this.pictureBox1.Size = new System.Drawing.Size(45, 44);
			this.pictureBox1.SizeMode = System.Windows.Forms.PictureBoxSizeMode.AutoSize;
			this.pictureBox1.TabIndex = 0;
			this.pictureBox1.TabStop = false;
			// 
			// grpInvoice
			// 
			this.grpInvoice.AccessibleDescription = "Invoice";
			this.grpInvoice.AccessibleName = "Invoice";
			this.grpInvoice.Anchor = ((System.Windows.Forms.AnchorStyles)(((System.Windows.Forms.AnchorStyles.Top | System.Windows.Forms.AnchorStyles.Left) 
				| System.Windows.Forms.AnchorStyles.Right)));
			this.grpInvoice.Controls.Add(this.cmbManufacturer);
			this.grpInvoice.Controls.Add(this.lblManufacturer);
			this.grpInvoice.Controls.Add(this.txtInvoiceNumber);
			this.grpInvoice.Controls.Add(this.lblInvoiceNumber);
			this.grpInvoice.Controls.Add(this.dtpReceivedDate);
			this.grpInvoice.Controls.Add(this.lblReceivedDate);
			this.grpInvoice.Location = new System.Drawing.Point(60, 36);
			this.grpInvoice.Name = "grpInvoice";
			this.grpInvoice.Size = new System.Drawing.Size(680, 92);
			this.grpInvoice.TabIndex = 0;
			this.grpInvoice.TabStop = false;
			this.grpInvoice.Text = "Invoice";
			// 
			// cmbManufacturer
			// 
			this.cmbManufacturer.AccessibleDescription = "Manufacturer";
			this.cmbManufacturer.AccessibleName = "Manufacturer";
			this.cmbManufacturer.Anchor = ((System.Windows.Forms.AnchorStyles)(((System.Windows.Forms.AnchorStyles.Top | System.Windows.Forms.AnchorStyles.Left) 
				| System.Windows.Forms.AnchorStyles.Right)));
			this.cmbManufacturer.Interval = 500;
			this.cmbManufacturer.Location = new System.Drawing.Point(164, 64);
			this.cmbManufacturer.MaxLength = 50;
			this.cmbManufacturer.Name = "cmbManufacturer";
			this.cmbManufacturer.Size = new System.Drawing.Size(506, 22);
			this.cmbManufacturer.TabIndex = 5;
			this.toolTip1.SetToolTip(this.cmbManufacturer, "Enter the manufacturer that supplied the reagent invoice. New manufacturers may b" +
				"e entered, or existing manufacturers selected from the list");
			this.cmbManufacturer.Leave += new System.EventHandler(this.cmbManufacturer_Leave);
			this.cmbManufacturer.TextChanged += new System.EventHandler(this.cmbManufacturer_TextChanged);
			this.cmbManufacturer.SelectedIndexChanged += new System.EventHandler(this.cmbManufacturer_SelectedIndexChanged);
			// 
			// lblManufacturer
			// 
			this.lblManufacturer.Location = new System.Drawing.Point(8, 64);
			this.lblManufacturer.Name = "lblManufacturer";
			this.lblManufacturer.Size = new System.Drawing.Size(144, 20);
			this.lblManufacturer.TabIndex = 4;
			this.lblManufacturer.Text = "Manufacturer*";
			this.lblManufacturer.TextAlign = System.Drawing.ContentAlignment.MiddleLeft;
			// 
			// txtInvoiceNumber
			// 
			this.txtInvoiceNumber.AccessibleDescription = "Invoice Number";
			this.txtInvoiceNumber.AccessibleName = "Invoice Number";
			this.txtInvoiceNumber.Location = new System.Drawing.Point(164, 40);
			this.txtInvoiceNumber.MaxLength = 20;
			this.txtInvoiceNumber.Name = "txtInvoiceNumber";
			this.txtInvoiceNumber.Size = new System.Drawing.Size(204, 20);
			this.txtInvoiceNumber.TabIndex = 3;
			this.txtInvoiceNumber.Text = "";
			this.toolTip1.SetToolTip(this.txtInvoiceNumber, "Enter the invoice number of the reagent invoice");
			this.txtInvoiceNumber.Leave += new System.EventHandler(this.txtInvoiceNumber_Leave);
			// 
			// lblInvoiceNumber
			// 
			this.lblInvoiceNumber.Location = new System.Drawing.Point(8, 40);
			this.lblInvoiceNumber.Name = "lblInvoiceNumber";
			this.lblInvoiceNumber.Size = new System.Drawing.Size(144, 20);
			this.lblInvoiceNumber.TabIndex = 2;
			this.lblInvoiceNumber.Text = "Invoice Number*";
			this.lblInvoiceNumber.TextAlign = System.Drawing.ContentAlignment.MiddleLeft;
			// 
			// dtpReceivedDate
			// 
			this.dtpReceivedDate.AccessibleDescription = "Received Date";
			this.dtpReceivedDate.AccessibleName = "Received Date";
			this.dtpReceivedDate.CustomFormat = "";
			this.dtpReceivedDate.Format = System.Windows.Forms.DateTimePickerFormat.Custom;
			this.dtpReceivedDate.Location = new System.Drawing.Point(164, 16);
			this.dtpReceivedDate.Name = "dtpReceivedDate";
			this.dtpReceivedDate.Size = new System.Drawing.Size(204, 20);
			this.dtpReceivedDate.TabIndex = 1;
			this.toolTip1.SetToolTip(this.dtpReceivedDate, "Enter the date and time that the reagent invoice was received");
			this.dtpReceivedDate.Leave += new System.EventHandler(this.dtpReceivedDate_Leave);
			this.dtpReceivedDate.ValueChanged += new System.EventHandler(this.dtpReceivedDate_Leave);
			// 
			// lblReceivedDate
			// 
			this.lblReceivedDate.Location = new System.Drawing.Point(8, 16);
			this.lblReceivedDate.Name = "lblReceivedDate";
			this.lblReceivedDate.Size = new System.Drawing.Size(144, 20);
			this.lblReceivedDate.TabIndex = 0;
			this.lblReceivedDate.Text = "Received Date*";
			this.lblReceivedDate.TextAlign = System.Drawing.ContentAlignment.MiddleLeft;
			// 
			// btnOK
			// 
			this.btnOK.Anchor = ((System.Windows.Forms.AnchorStyles)((System.Windows.Forms.AnchorStyles.Bottom | System.Windows.Forms.AnchorStyles.Right)));
			this.btnOK.DialogResult = System.Windows.Forms.DialogResult.OK;
			this.btnOK.EnabledButton = false;
			this.btnOK.Font = new System.Drawing.Font("Arial", 8.25F, System.Drawing.FontStyle.Regular, System.Drawing.GraphicsUnit.Point, ((System.Byte)(0)));
			this.btnOK.Image = ((System.Drawing.Image)(resources.GetObject("btnOK.Image")));
			this.btnOK.Location = new System.Drawing.Point(584, 496);
			this.btnOK.Name = "btnOK";
			this.btnOK.Size = new System.Drawing.Size(75, 23);
			this.btnOK.TabIndex = 3;
			this.btnOK.Click += new System.EventHandler(this.btnOK_Click);
			// 
			// btnCancel
			// 
			this.btnCancel.Anchor = ((System.Windows.Forms.AnchorStyles)((System.Windows.Forms.AnchorStyles.Bottom | System.Windows.Forms.AnchorStyles.Right)));
			this.btnCancel.DialogResult = System.Windows.Forms.DialogResult.Cancel;
			this.btnCancel.Location = new System.Drawing.Point(664, 496);
			this.btnCancel.Name = "btnCancel";
			this.btnCancel.TabIndex = 4;
			this.btnCancel.Text = "&Cancel";
			this.toolTip1.SetToolTip(this.btnCancel, "Click to disregard changes and return");
			this.btnCancel.Click += new System.EventHandler(this.btnCancel_Click);
			// 
			// grpReagent
			// 
			this.grpReagent.AccessibleDescription = "Reagent";
			this.grpReagent.AccessibleName = "Reagent";
			this.grpReagent.Anchor = ((System.Windows.Forms.AnchorStyles)(((System.Windows.Forms.AnchorStyles.Top | System.Windows.Forms.AnchorStyles.Left) 
				| System.Windows.Forms.AnchorStyles.Right)));
			this.grpReagent.Controls.Add(this.updVials);
			this.grpReagent.Controls.Add(this.dtpExpirationDate);
			this.grpReagent.Controls.Add(this.groupBox1);
			this.grpReagent.Controls.Add(this.btnClear);
			this.grpReagent.Controls.Add(this.cmbManufacturerReagentName);
			this.grpReagent.Controls.Add(this.btnAdd);
			this.grpReagent.Controls.Add(this.lblVials);
			this.grpReagent.Controls.Add(this.lblExpirationDate);
			this.grpReagent.Controls.Add(this.txtLotNumber);
			this.grpReagent.Controls.Add(this.lblLotNumber);
			this.grpReagent.Controls.Add(this.cmbReagentType);
			this.grpReagent.Controls.Add(this.lblReagentType);
			this.grpReagent.Controls.Add(this.lblManufacturerReagentName);
			this.grpReagent.Enabled = false;
			this.grpReagent.Location = new System.Drawing.Point(60, 132);
			this.grpReagent.Name = "grpReagent";
			this.grpReagent.Size = new System.Drawing.Size(680, 176);
			this.grpReagent.TabIndex = 1;
			this.grpReagent.TabStop = false;
			this.grpReagent.Text = "Reagent";
			// 
			// updVials
			// 
			this.updVials.AccessibleDescription = "Vials Received per Lot Number";
			this.updVials.AccessibleName = "Vials Received per Lot Number";
			this.updVials.Location = new System.Drawing.Point(164, 112);
			this.updVials.Maximum = new System.Decimal(new int[] {
																	 999,
																	 0,
																	 0,
																	 0});
			this.updVials.Name = "updVials";
			this.updVials.Size = new System.Drawing.Size(52, 20);
			this.updVials.TabIndex = 9;
			this.updVials.TextAlign = System.Windows.Forms.HorizontalAlignment.Right;
			this.updVials.Value = new System.Decimal(new int[] {
																   0,
																   0,
																   0,
																   0});
			this.updVials.TextChanged += new System.EventHandler(this.updVials_ValueChanged);
			this.updVials.Leave += new System.EventHandler(this.updVials_Leave);
			this.updVials.ValueChanged += new System.EventHandler(this.updVials_ValueChanged);
			// 
			// dtpExpirationDate
			// 
			this.dtpExpirationDate.AccessibleDescription = "Lot Expiration Date";
			this.dtpExpirationDate.AccessibleName = "Lot Expiration Date";
			this.dtpExpirationDate.Format = System.Windows.Forms.DateTimePickerFormat.Custom;
			this.dtpExpirationDate.Location = new System.Drawing.Point(164, 88);
			this.dtpExpirationDate.Name = "dtpExpirationDate";
			this.dtpExpirationDate.Size = new System.Drawing.Size(204, 20);
			this.dtpExpirationDate.TabIndex = 7;
			this.dtpExpirationDate.Leave += new System.EventHandler(this.dtpExpirationDate_Leave);
			// 
			// groupBox1
			// 
			this.groupBox1.AccessibleDescription = "Visual Inspection";
			this.groupBox1.AccessibleName = "Visual Inspection";
			this.groupBox1.Anchor = ((System.Windows.Forms.AnchorStyles)((((System.Windows.Forms.AnchorStyles.Top | System.Windows.Forms.AnchorStyles.Bottom) 
				| System.Windows.Forms.AnchorStyles.Left) 
				| System.Windows.Forms.AnchorStyles.Right)));
			this.groupBox1.Controls.Add(this.pnlComment);
			this.groupBox1.Controls.Add(this.rdoSatisfactory);
			this.groupBox1.Controls.Add(this.rdoUnsatisfactory);
			this.groupBox1.Location = new System.Drawing.Point(376, 8);
			this.groupBox1.Name = "groupBox1";
			this.groupBox1.Size = new System.Drawing.Size(294, 132);
			this.groupBox1.TabIndex = 10;
			this.groupBox1.TabStop = false;
			this.groupBox1.Text = "Visual Inspection*";
			// 
			// pnlComment
			// 
			this.pnlComment.Anchor = ((System.Windows.Forms.AnchorStyles)((((System.Windows.Forms.AnchorStyles.Top | System.Windows.Forms.AnchorStyles.Bottom) 
				| System.Windows.Forms.AnchorStyles.Left) 
				| System.Windows.Forms.AnchorStyles.Right)));
			this.pnlComment.Controls.Add(this.lblDetails);
			this.pnlComment.Controls.Add(this.lblComment);
			this.pnlComment.Controls.Add(this.txtComments);
			this.pnlComment.Controls.Add(this.cmbComment);
			this.pnlComment.Location = new System.Drawing.Point(24, 56);
			this.pnlComment.Name = "pnlComment";
			this.pnlComment.Size = new System.Drawing.Size(264, 68);
			this.pnlComment.TabIndex = 2;
			// 
			// lblDetails
			// 
			this.lblDetails.Location = new System.Drawing.Point(0, 28);
			this.lblDetails.Name = "lblDetails";
			this.lblDetails.Size = new System.Drawing.Size(60, 20);
			this.lblDetails.TabIndex = 2;
			this.lblDetails.Text = "Details";
			this.lblDetails.TextAlign = System.Drawing.ContentAlignment.MiddleLeft;
			// 
			// lblComment
			// 
			this.lblComment.Location = new System.Drawing.Point(0, 4);
			this.lblComment.Name = "lblComment";
			this.lblComment.Size = new System.Drawing.Size(60, 20);
			this.lblComment.TabIndex = 0;
			this.lblComment.Text = "Comment*";
			this.lblComment.TextAlign = System.Drawing.ContentAlignment.MiddleLeft;
			// 
			// txtComments
			// 
			this.txtComments.AccessibleDescription = "Details";
			this.txtComments.AccessibleName = "Details";
			this.txtComments.Anchor = ((System.Windows.Forms.AnchorStyles)((((System.Windows.Forms.AnchorStyles.Top | System.Windows.Forms.AnchorStyles.Bottom) 
				| System.Windows.Forms.AnchorStyles.Left) 
				| System.Windows.Forms.AnchorStyles.Right)));
			this.txtComments.Location = new System.Drawing.Point(60, 28);
			this.txtComments.MaxLength = 255;
			this.txtComments.Multiline = true;
			this.txtComments.Name = "txtComments";
			this.txtComments.Size = new System.Drawing.Size(200, 40);
			this.txtComments.TabIndex = 3;
			this.txtComments.Text = "";
			this.toolTip1.SetToolTip(this.txtComments, "Enter the lot number of the reagent being logged in");
			this.txtComments.TextChanged += new System.EventHandler(this.txtComments_TextChanged);
			// 
			// cmbComment
			// 
			this.cmbComment.AccessibleDescription = "Comment";
			this.cmbComment.AccessibleName = "Comment";
			this.cmbComment.Anchor = ((System.Windows.Forms.AnchorStyles)(((System.Windows.Forms.AnchorStyles.Top | System.Windows.Forms.AnchorStyles.Left) 
				| System.Windows.Forms.AnchorStyles.Right)));
			this.cmbComment.Interval = 500;
			this.cmbComment.Location = new System.Drawing.Point(60, 4);
			this.cmbComment.Name = "cmbComment";
			this.cmbComment.Size = new System.Drawing.Size(200, 22);
			this.cmbComment.TabIndex = 1;
			this.cmbComment.SelectedIndexChanged += new System.EventHandler(this.cmbComment_SelectedIndexChanged);
			// 
			// rdoSatisfactory
			// 
			this.rdoSatisfactory.AccessibleDescription = "Satisfactory";
			this.rdoSatisfactory.AccessibleName = "Satisfactory";
			this.rdoSatisfactory.Anchor = ((System.Windows.Forms.AnchorStyles)(((System.Windows.Forms.AnchorStyles.Top | System.Windows.Forms.AnchorStyles.Left) 
				| System.Windows.Forms.AnchorStyles.Right)));
			this.rdoSatisfactory.Enabled = false;
			this.rdoSatisfactory.Location = new System.Drawing.Point(8, 16);
			this.rdoSatisfactory.Name = "rdoSatisfactory";
			this.rdoSatisfactory.Size = new System.Drawing.Size(274, 20);
			this.rdoSatisfactory.TabIndex = 0;
			this.rdoSatisfactory.TabStop = true;
			this.rdoSatisfactory.Text = "&Satisfactory";
			this.toolTip1.SetToolTip(this.rdoSatisfactory, "Check box to mark inspection as satisfactory or unsatisfactory");
			this.rdoSatisfactory.Click += new System.EventHandler(this.rdoSatisfactory_Click);
			this.rdoSatisfactory.CheckedChanged += new System.EventHandler(this.rdoSatisfactory_Click);
			// 
			// rdoUnsatisfactory
			// 
			this.rdoUnsatisfactory.AccessibleDescription = "Unsatisfactory";
			this.rdoUnsatisfactory.AccessibleName = "Unsatisfactory";
			this.rdoUnsatisfactory.Anchor = ((System.Windows.Forms.AnchorStyles)(((System.Windows.Forms.AnchorStyles.Top | System.Windows.Forms.AnchorStyles.Left) 
				| System.Windows.Forms.AnchorStyles.Right)));
			this.rdoUnsatisfactory.Enabled = false;
			this.rdoUnsatisfactory.Location = new System.Drawing.Point(8, 36);
			this.rdoUnsatisfactory.Name = "rdoUnsatisfactory";
			this.rdoUnsatisfactory.Size = new System.Drawing.Size(274, 20);
			this.rdoUnsatisfactory.TabIndex = 1;
			this.rdoUnsatisfactory.TabStop = true;
			this.rdoUnsatisfactory.Text = "U&nsatisfactory";
			this.toolTip1.SetToolTip(this.rdoUnsatisfactory, "Check box to mark inspection as satisfactory or unsatisfactory");
			this.rdoUnsatisfactory.Click += new System.EventHandler(this.rdoUnsatisfactory_Click);
			this.rdoUnsatisfactory.CheckedChanged += new System.EventHandler(this.rdoUnsatisfactory_Click);
			// 
			// btnClear
			// 
			this.btnClear.Anchor = ((System.Windows.Forms.AnchorStyles)((System.Windows.Forms.AnchorStyles.Bottom | System.Windows.Forms.AnchorStyles.Right)));
			this.btnClear.Location = new System.Drawing.Point(596, 144);
			this.btnClear.Name = "btnClear";
			this.btnClear.TabIndex = 12;
			this.btnClear.Text = "C&lear";
			this.toolTip1.SetToolTip(this.btnClear, "Click to clear details of reagent for re-entry");
			this.btnClear.Click += new System.EventHandler(this.btnClear_Click);
			// 
			// cmbManufacturerReagentName
			// 
			this.cmbManufacturerReagentName.AccessibleDescription = "Manufacturer Reagent Name";
			this.cmbManufacturerReagentName.AccessibleName = "Manufacturer Reagent Name";
			this.cmbManufacturerReagentName.Interval = 500;
			this.cmbManufacturerReagentName.Location = new System.Drawing.Point(164, 12);
			this.cmbManufacturerReagentName.MaxLength = 75;
			this.cmbManufacturerReagentName.Name = "cmbManufacturerReagentName";
			this.cmbManufacturerReagentName.Size = new System.Drawing.Size(204, 22);
			this.cmbManufacturerReagentName.TabIndex = 1;
			this.toolTip1.SetToolTip(this.cmbManufacturerReagentName, "Enter the name of the reagent being logged in, as defined by the manufacturer. Se" +
				"lect an exisiting name from the list, or enter a new name");
			this.cmbManufacturerReagentName.Leave += new System.EventHandler(this.cmbManufacturerReagentName_Leave);
			this.cmbManufacturerReagentName.TextChanged += new System.EventHandler(this.cmbManufacturerReagentName_TextChanged);
			this.cmbManufacturerReagentName.SelectedIndexChanged += new System.EventHandler(this.cmbManufacturerReagentName_SelectedIndexChanged);
			// 
			// btnAdd
			// 
			this.btnAdd.Anchor = ((System.Windows.Forms.AnchorStyles)((System.Windows.Forms.AnchorStyles.Bottom | System.Windows.Forms.AnchorStyles.Right)));
			this.btnAdd.EnabledButton = false;
			this.btnAdd.Font = new System.Drawing.Font("Arial", 8.25F, System.Drawing.FontStyle.Regular, System.Drawing.GraphicsUnit.Point, ((System.Byte)(0)));
			this.btnAdd.Image = ((System.Drawing.Image)(resources.GetObject("btnAdd.Image")));
			this.btnAdd.Location = new System.Drawing.Point(516, 144);
			this.btnAdd.Name = "btnAdd";
			this.btnAdd.Size = new System.Drawing.Size(75, 23);
			this.btnAdd.TabIndex = 11;
			this.btnAdd.Click += new System.EventHandler(this.btnAdd_Click);
			// 
			// lblVials
			// 
			this.lblVials.Location = new System.Drawing.Point(8, 112);
			this.lblVials.Name = "lblVials";
			this.lblVials.Size = new System.Drawing.Size(168, 20);
			this.lblVials.TabIndex = 8;
			this.lblVials.Text = "Vials Received per Lot Number*";
			this.lblVials.TextAlign = System.Drawing.ContentAlignment.MiddleLeft;
			// 
			// lblExpirationDate
			// 
			this.lblExpirationDate.Location = new System.Drawing.Point(8, 88);
			this.lblExpirationDate.Name = "lblExpirationDate";
			this.lblExpirationDate.Size = new System.Drawing.Size(144, 20);
			this.lblExpirationDate.TabIndex = 6;
			this.lblExpirationDate.Text = "Lot Expiraton Date*";
			this.lblExpirationDate.TextAlign = System.Drawing.ContentAlignment.MiddleLeft;
			// 
			// txtLotNumber
			// 
			this.txtLotNumber.AccessibleDescription = "Lot Number";
			this.txtLotNumber.AccessibleName = "Lot Number";
			this.txtLotNumber.Enabled = false;
			this.txtLotNumber.Location = new System.Drawing.Point(164, 64);
			this.txtLotNumber.MaxLength = 15;
			this.txtLotNumber.Name = "txtLotNumber";
			this.txtLotNumber.Size = new System.Drawing.Size(204, 20);
			this.txtLotNumber.TabIndex = 5;
			this.txtLotNumber.Text = "";
			this.toolTip1.SetToolTip(this.txtLotNumber, "Enter the lot number of the reagent being logged in");
			this.txtLotNumber.Leave += new System.EventHandler(this.txtLotNumber_Leave);
			// 
			// lblLotNumber
			// 
			this.lblLotNumber.Location = new System.Drawing.Point(8, 64);
			this.lblLotNumber.Name = "lblLotNumber";
			this.lblLotNumber.Size = new System.Drawing.Size(144, 20);
			this.lblLotNumber.TabIndex = 4;
			this.lblLotNumber.Text = "Lot Number*";
			this.lblLotNumber.TextAlign = System.Drawing.ContentAlignment.MiddleLeft;
			// 
			// cmbReagentType
			// 
			this.cmbReagentType.AccessibleDescription = "Reagent Type";
			this.cmbReagentType.AccessibleName = "Reagent Type";
			this.cmbReagentType.Enabled = false;
			this.cmbReagentType.Interval = 500;
			this.cmbReagentType.Location = new System.Drawing.Point(164, 38);
			this.cmbReagentType.Name = "cmbReagentType";
			this.cmbReagentType.Size = new System.Drawing.Size(204, 22);
			this.cmbReagentType.TabIndex = 3;
			this.toolTip1.SetToolTip(this.cmbReagentType, "Select the type of regeant being logged in");
			this.cmbReagentType.Leave += new System.EventHandler(this.cmbReagentType_Leave);
			this.cmbReagentType.SelectedIndexChanged += new System.EventHandler(this.cmbReagentType_Leave);
			// 
			// lblReagentType
			// 
			this.lblReagentType.Location = new System.Drawing.Point(8, 40);
			this.lblReagentType.Name = "lblReagentType";
			this.lblReagentType.Size = new System.Drawing.Size(144, 20);
			this.lblReagentType.TabIndex = 2;
			this.lblReagentType.Text = "Reagent Type*";
			this.lblReagentType.TextAlign = System.Drawing.ContentAlignment.MiddleLeft;
			// 
			// lblManufacturerReagentName
			// 
			this.lblManufacturerReagentName.Location = new System.Drawing.Point(8, 16);
			this.lblManufacturerReagentName.Name = "lblManufacturerReagentName";
			this.lblManufacturerReagentName.Size = new System.Drawing.Size(156, 20);
			this.lblManufacturerReagentName.TabIndex = 0;
			this.lblManufacturerReagentName.Text = "Manufacturer Reagent Name*";
			this.lblManufacturerReagentName.TextAlign = System.Drawing.ContentAlignment.MiddleLeft;
			// 
			// grpInventory
			// 
			this.grpInventory.AccessibleDescription = "Inventory";
			this.grpInventory.AccessibleName = "Inventory";
			this.grpInventory.Anchor = ((System.Windows.Forms.AnchorStyles)((((System.Windows.Forms.AnchorStyles.Top | System.Windows.Forms.AnchorStyles.Bottom) 
				| System.Windows.Forms.AnchorStyles.Left) 
				| System.Windows.Forms.AnchorStyles.Right)));
			this.grpInventory.Controls.Add(this.lvInventory);
			this.grpInventory.Location = new System.Drawing.Point(60, 312);
			this.grpInventory.Name = "grpInventory";
			this.grpInventory.Size = new System.Drawing.Size(680, 176);
			this.grpInventory.TabIndex = 2;
			this.grpInventory.TabStop = false;
			this.grpInventory.Text = "Inventory";
			// 
			// lvInventory
			// 
			this.lvInventory.AccessibleDescription = "Inventory";
			this.lvInventory.AccessibleName = "Inventory";
			this.lvInventory.Anchor = ((System.Windows.Forms.AnchorStyles)((((System.Windows.Forms.AnchorStyles.Top | System.Windows.Forms.AnchorStyles.Bottom) 
				| System.Windows.Forms.AnchorStyles.Left) 
				| System.Windows.Forms.AnchorStyles.Right)));
			this.lvInventory.CheckBoxes = true;
			this.lvInventory.Columns.AddRange(new System.Windows.Forms.ColumnHeader[] {
																						  this.colCheckBox,
																						  this.colReagentName,
																						  this.colLotNumber,
																						  this.colExpirationDate,
																						  this.colVials,
																						  this.colInvoice,
																						  this.colManufacturer,
																						  this.colReagentType,
																						  this.colInspection});
			this.lvInventory.FullRowSelect = true;
			this.lvInventory.Location = new System.Drawing.Point(8, 16);
			this.lvInventory.MultiSelect = false;
			this.lvInventory.Name = "lvInventory";
			this.lvInventory.Size = new System.Drawing.Size(664, 152);
			this.lvInventory.TabIndex = 0;
			this.toolTip1.SetToolTip(this.lvInventory, "Current invoice inventory. Uncheck box to remove from inventory, or click an entr" +
				"y to edit details before saving");
			this.lvInventory.View = System.Windows.Forms.View.Details;
			this.lvInventory.ColumnClick += new System.Windows.Forms.ColumnClickEventHandler(this.lvInventory_ColumnClick);
			this.lvInventory.SelectedIndexChanged += new System.EventHandler(this.lvInventory_SelectedIndexChanged);
			// 
			// colCheckBox
			// 
			this.colCheckBox.Text = "";
			this.colCheckBox.Width = 25;
			// 
			// colReagentName
			// 
			this.colReagentName.Text = "Reagent Name";
			this.colReagentName.Width = 120;
			// 
			// colLotNumber
			// 
			this.colLotNumber.Text = "Lot Number";
			this.colLotNumber.Width = 90;
			// 
			// colExpirationDate
			// 
			this.colExpirationDate.Text = "Expiration";
			this.colExpirationDate.Width = 80;
			// 
			// colVials
			// 
			this.colVials.Text = "Vials/Sets";
			this.colVials.Width = 72;
			// 
			// colInvoice
			// 
			this.colInvoice.Text = "Invoice";
			this.colInvoice.Width = 90;
			// 
			// colManufacturer
			// 
			this.colManufacturer.Text = "Manufacturer Name";
			this.colManufacturer.Width = 150;
			// 
			// colReagentType
			// 
			this.colReagentType.Text = "Reagent Type";
			this.colReagentType.Width = 80;
			// 
			// colInspection
			// 
			this.colInspection.Text = "Inspection";
			this.colInspection.Width = 90;
			// 
			// FrmLogInReagents
			// 
			this.AcceptButton = this.btnOK;
			this.AutoScaleBaseSize = new System.Drawing.Size(5, 13);
			this.CancelButton = this.btnCancel;
			this.ClientSize = new System.Drawing.Size(742, 523);
			this.Controls.Add(this.grpInventory);
			this.Controls.Add(this.grpReagent);
			this.Controls.Add(this.btnCancel);
			this.Controls.Add(this.btnOK);
			this.Controls.Add(this.grpInvoice);
			this.Controls.Add(this.grpImage);
			this.hlphelpChm.SetHelpKeyword(this, "Log_in_Reagents.htm");
			this.hlphelpChm.SetHelpNavigator(this, System.Windows.Forms.HelpNavigator.Topic);
			this.MinimumSize = new System.Drawing.Size(660, 524);
			this.Name = "FrmLogInReagents";
			this.RequiredFieldsLabel = true;
			this.hlphelpChm.SetShowHelp(this, true);
			this.Text = "VBECS - Log In Reagents";
			this.KeyDownSpeakMessage += new gov.va.med.vbecs.GUI.VbecsBaseForm.KeyDownSpeakMessageEventHandler(this.FrmLogInReagents_KeyDownSpeakMessage);
			this.Controls.SetChildIndex(this.grpImage, 0);
			this.Controls.SetChildIndex(this.grpInvoice, 0);
			this.Controls.SetChildIndex(this.btnOK, 0);
			this.Controls.SetChildIndex(this.btnCancel, 0);
			this.Controls.SetChildIndex(this.grpReagent, 0);
			this.Controls.SetChildIndex(this.grpInventory, 0);
			this.Controls.SetChildIndex(this.vbecsLogo1, 0);
			this.Controls.SetChildIndex(this.lblRequiredField, 0);
			this.grpImage.ResumeLayout(false);
			this.grpInvoice.ResumeLayout(false);
			this.grpReagent.ResumeLayout(false);
			((System.ComponentModel.ISupportInitialize)(this.updVials)).EndInit();
			this.groupBox1.ResumeLayout(false);
			this.pnlComment.ResumeLayout(false);
			this.grpInventory.ResumeLayout(false);
			this.ResumeLayout(false);

		}
		#endregion

		#region Methods
		private void SetComponentProperties()
		{
			this.vbecsLogo1.Title = "Log In Reagents";
			// CR 2693
			// hlpHelp
			// 
			this.hlpHelp.HelpNamespace = Environment.CurrentDirectory+"\\VBECS.chm";
			// 
			// hlphelpChm
			// 
			this.hlphelpChm.HelpNamespace = Environment.CurrentDirectory+"\\VBECS.chm";
			// 
			//
			this.SetThisHelpFile(this, Common.StrRes.HelpFiles.UC020.FrmLogInReagents());
			//
			this.btnAdd.Text = "&Add";
			this.btnAdd.EnabledButton = false;
			this.btnAdd.SetToolTip(StrRes.Tooltips.Common.EnterRequiredData().ResString);

			this.btnOK.Text = "&OK";
			this.btnOK.EnabledButton = false;
			this.btnOK.SetToolTip(StrRes.Tooltips.UC020.AddAtLeastOne().ResString);
			
			//set custom date and time format
			this.dtpReceivedDate.CustomFormat = VBECSDateTime.DateTimeFormat;
			this.dtpExpirationDate.CustomFormat = VBECSDateTime.DateTimeFormat;

			//set current date value based on the division time zone
			System.DateTime _currentDate = BOL.VBECSDateTime.GetDivisionCurrentDateTime();
			this.dtpReceivedDate.Value = _currentDate;
			this.dtpExpirationDate.Value = _currentDate.Date.AddHours(23).AddMinutes(59);

			this.cmbManufacturer.LookupEnabled = false;
			this.cmbManufacturerReagentName.LookupEnabled = false;
		}

		/// <summary>
		/// Load the list of reagent manufacturers
		/// </summary>
		private void LoadReagentManufacturers()
		{
			try
			{
				_dtManufacturers = BOL.Reagent.GetReagentManufacturers();
				foreach (DataRow drManufacturer in _dtManufacturers.Rows)
				{
					cmbManufacturer.Items.Add(drManufacturer[Common.VbecsTables.Reagent.ReagentManufacturerName]);
				}
			}
			catch (Exception err)
			{
				GuiMessenger.ShowMessageBox(StrRes.SysErrMsg.Common.UnexpectedException( err ));
			}
		}

		/// <summary>
		/// Load the list of reagent names associated with certain manufacturer
		/// </summary>
		private void LoadManufacturerReagentNames()
		{
			cmbManufacturerReagentName.Items.Clear();
			try
			{
				_dtManufacturerReagentNames = BOL.Reagent.GetManufacturerReagentNames(cmbManufacturer.Text.Trim());
				foreach (DataRow drReagentName in _dtManufacturerReagentNames.Rows)
				{
					if (cmbManufacturerReagentName.Items.IndexOf(drReagentName[Common.VbecsTables.Reagent.ReagentName]) == -1)
					{
						cmbManufacturerReagentName.Items.Add(drReagentName[Common.VbecsTables.Reagent.ReagentName]);
					}
				}
			}
			catch (Exception err)
			{
				GuiMessenger.ShowMessageBox(StrRes.SysErrMsg.Common.UnexpectedException( err ));
			}
		}

		/// <summary>
		/// Load the list of reagent types
		/// </summary>
		private void LoadReagentTypes()
		{
			try
			{
				_dtReagentTypes = BOL.ReagentType.GetReagentTypes();
				DataRow[] drReagents = _dtReagentTypes.Select(Common.VbecsTables.ReagentType.SortColumn + "<> 99", Common.VbecsTables.ReagentType.SortColumn + " ASC");
				foreach(DataRow drReagentType in drReagents)
				{
					cmbReagentType.Items.Add(drReagentType[Common.VbecsTables.ReagentType.ReagentTypeName]);
				}
			}
			catch (Exception err)
			{
				GuiMessenger.ShowMessageBox(StrRes.SysErrMsg.Common.UnexpectedException( err ));
			}
		}

		/// <summary>
		/// Load the list of canned comments
		/// </summary>
		private void LoadCannedComments()
		{
			try
			{
				_dtCannedComments = BOL.CannedComment.GetCannedComments(LogonUser.LogonUserDivisionCode, "RS");
				foreach(DataRow drCannedComment in _dtCannedComments.Rows)
				{
					cmbComment.Items.Add(drCannedComment[Common.VbecsTables.CannedComment.CannedCommentText]);
				}
			}
			catch (Exception err)
			{
				GuiMessenger.ShowMessageBox(StrRes.SysErrMsg.Common.UnexpectedException( err ));
			}
		}

		/// <summary>
		/// Checks if the invoice data are valid
		/// BR_20.03
		/// </summary>
		private void CheckForValidInvoiceData()
		{
			if( !_bValidReceivedDate || !_bValidInvoice || !_bValidManufacturer )
			{
				ClearReagentData(true);
			}
			else
			{
				grpReagent.Enabled = true;
			}
		}

		/// <summary>
		/// Disables the reagent group on the screen and sets all the controls inside to default values
		/// </summary>
		/// <returns></returns>
		private void ClearReagentData(bool _bDisable)
		{
			if(_bDisable)
			{
				this.grpReagent.Enabled = false;
			}
			this.cmbManufacturerReagentName.Text = String.Empty;
			this.cmbReagentType.Text = String.Empty;
			this.txtLotNumber.Text = String.Empty;
			this.dtpExpirationDate.Value = BOL.VBECSDateTime.GetDivisionCurrentDateTime().Date.AddHours(23).AddMinutes(59);
			this.updVials.Value = 0;
			this.errError.SetVbecsError(this.updVials, ""); // **** 508 Compliance ***
			this.btnAdd.EnabledButton = false;
			this.btnAdd.SetToolTip(StrRes.Tooltips.Common.EnterRequiredData().ResString);
			this.rdoSatisfactory.Checked = false;
			this.rdoUnsatisfactory.Checked = false;
			//Setting both of these to unchecked will result in 
			//the radio buttons losing their tabstop value
			//don't ask me why, ask microsoft.
			this.rdoSatisfactory.TabStop = true;
			this.cmbComment.SelectedIndex = -1;
			this.cmbComment.Text = "";
			this.txtComments.Text = string.Empty;
			this.lvInventory.SelectedItems.Clear();

			_bValidReagentName = false;
			_bValidReagentType = false;
			_bValidLotNumber = false;
			_bValidExpirationDate = true;
			_bValidVials = false;
			_bValidTests = true;
			_bValidInspection = false;

			this.cmbReagentType.Enabled = false;
			this.txtLotNumber.Enabled = false;
			this.dtpExpirationDate.Enabled = false;
			this.rdoSatisfactory.Enabled = false;
			this.rdoUnsatisfactory.Enabled = false;
			this.updVials.Enabled = false;
			this.txtComments.Enabled = false;
			this.cmbComment.Enabled = false;

			this.btnAdd.Text = "&Add";
		}

		/// <summary>
		/// Checks if the reagent data are valid
		/// BR_20.03
		/// </summary>
		private void CheckForValidReagentData()
		{
			if (_bValidReagentName == false || _bValidReagentType == false || _bValidLotNumber == false ||
				_bValidExpirationDate == false || _bValidVials == false || _bValidTests == false ||
				_bValidInspection == false)
			{
				this.btnAdd.EnabledButton = false;
				this.btnAdd.SetToolTip(StrRes.Tooltips.Common.EnterRequiredData().ResString);
			}
			else
			{
				this.btnAdd.EnabledButton = true;
				this.btnAdd.SetToolTip("");
			}
		}

		#endregion

		#region Events/Event Handlers
		private void cmbManufacturer_Leave(object sender, System.EventArgs e)
		{
			if (!this.RecursionGuard)
			{
				this.RecursionGuard = true;

				try
				{
					if(cmbManufacturer.Text.Trim().Length == 0)
					{
						_bValidManufacturer = false;
					}
					else
					{
						_bValidManufacturer = true;
						LoadManufacturerReagentNames();
					}
					CheckForValidInvoiceData();
				}
				finally
				{
					this.RecursionGuard = false;
				}
			}
			if (this.cmbManufacturer.Text != "")
				this.IsDirty = true;
		}

		private void cmbManufacturer_SelectedIndexChanged(object sender, System.EventArgs e)
		{
			if(cmbManufacturer.Text.Trim().Length == 0)
			{
				_bValidManufacturer = false;
			}
			else
			{
				_bValidManufacturer = true;
			}
			if (this.cmbManufacturer.Text != "")
				this.IsDirty = true;
			CheckForValidInvoiceData();
		}

		private void dtpReceivedDate_Leave(object sender, System.EventArgs e)
		{
			if (!this.RecursionGuard)
			{
				this.RecursionGuard = true;

				try
				{
					if (dtpReceivedDate.Value > BOL.VBECSDateTime.GetDivisionCurrentDateTime())
					{
						this.errError.SetVbecsError(this.dtpReceivedDate, "The received date cannot be in a future"); // **** 508 Compliance ***
						_bValidReceivedDate = false;
					}
					else
					{
						_bValidReceivedDate = true;
						this.errError.SetVbecsError(this.dtpReceivedDate, ""); // **** 508 Compliance ***
					}
					CheckForValidInvoiceData();
				}
				catch(Exception err)
				{
					this.errError.SetVbecsError(this.dtpReceivedDate, err.Message); // **** 508 Compliance ***
				}
				finally
				{
					this.RecursionGuard = false;
				}
			}
		}

		private void txtInvoiceNumber_Leave(object sender, System.EventArgs e)
		{
			if (!this.RecursionGuard)
			{
				this.RecursionGuard = true;

				try
				{
					if(this.txtInvoiceNumber.Text.Trim().Length == 0)
					{
						_bValidInvoice = false;
					}
					else
					{
						_bValidInvoice = true;
					}
					CheckForValidInvoiceData();
				}
				finally
				{
					this.RecursionGuard = false;
				}

				if (this.cmbReagentType.Text.Trim() != "" &&
					this.txtLotNumber.Text.Trim() != "")
				{
					CheckForExistingReagentInInvoice();
				}
			}
			if (this.txtInvoiceNumber.Text != "")
				this.IsDirty = true;
		}

		private void cmbManufacturerReagentName_Leave(object sender, System.EventArgs e)
		{
			if (!this.RecursionGuard)
			{
				this.RecursionGuard = true;

				try
				{
					if(cmbManufacturerReagentName.Text.Trim().Length == 0)
					{
						_bValidReagentName = false;
					}
					else
					{
						_bValidReagentName = true;
						this.cmbReagentType.Enabled = true;
						this.txtLotNumber.Enabled = true;
						this.dtpExpirationDate.Enabled = true;
						this.rdoSatisfactory.Enabled = true;
						this.rdoUnsatisfactory.Enabled = true;
						this.updVials.Enabled = true;
						this.cmbReagentType.Focus();
					}
					CheckForValidReagentData();
				}
				finally
				{
					this.RecursionGuard = false;
				}
			}
		}

		private void cmbManufacturerReagentName_SelectedIndexChanged(object sender, System.EventArgs e)
		{
			if(cmbManufacturerReagentName.Text.Trim().Length == 0)
			{
				_bValidReagentName = false;
			}
			else if (cmbManufacturerReagentName.SelectedIndex != -1)
			{
				_bValidReagentName = true;
				this.cmbReagentType.Enabled = true;
				this.txtLotNumber.Enabled = true;
				this.dtpExpirationDate.Enabled = true;
				this.rdoSatisfactory.Enabled = true;
				this.rdoUnsatisfactory.Enabled = true;
				this.updVials.Enabled = true;
				this.cmbReagentType.Focus();
			}
			CheckForValidReagentData();
		}

		private void cmbReagentType_Leave(object sender, System.EventArgs e)
		{
			if (cmbReagentType.Items.IndexOf(cmbReagentType.Text) == -1)
			{
				_bValidReagentType = false;
			}
			else
			{
				_bValidReagentType = true;
			}
			CheckForValidReagentData();
			if (this.txtLotNumber.Text.Trim() != "")
				CheckForExistingReagentInInvoice();
		}

		private void txtLotNumber_Leave(object sender, System.EventArgs e)
		{
			if(txtLotNumber.Text.Trim().Length == 0)
			{
				_bValidLotNumber = false;
			}
			else
			{
				_bValidLotNumber = true;
			}
			CheckForValidReagentData();
			if (this.cmbReagentType.Text.Trim() != "")
				CheckForExistingReagentInInvoice();
		}

		private void dtpExpirationDate_Leave(object sender, System.EventArgs e)
		{
			CheckForValidReagentData();
		}

		private void updVials_ValueChanged(object sender, System.EventArgs e)
		{
			try
			{
				if(updVials.Value == 0)
				{
					this.errError.SetVbecsError(this.updVials, "Number of vials must be greater than 0"); // **** 508 Compliance ***
					_bValidVials = false;
				}
				else
				{
					this.errError.SetVbecsError(this.updVials, ""); // **** 508 Compliance ***
					_bValidVials = true;
				}
			}
			catch(FormatException)
			{
				_bValidVials = false;
			}
			CheckForValidReagentData();
		}

		private void updVials_Leave(object sender, System.EventArgs e)
		{
			try
			{
				if(updVials.Value == 0)
				{
					this.errError.SetVbecsError(this.updVials, "Number of vials must be greater than 0"); // **** 508 Compliance ***
					_bValidVials = false;
				}
				else
				{
					this.errError.SetVbecsError(this.updVials, ""); // **** 508 Compliance ***
					_bValidVials = true;
				}
			}
			catch(FormatException err)
			{
				_bValidVials = false;
				this.errError.SetVbecsError(this.updVials, err.Message); // **** 508 Compliance ***
			}
			CheckForValidReagentData();
		}

		private void CheckForExistingReagentInInvoice()
		{

			if (this.btnAdd.Text == "&Add")
			{
				//check if reagent is already in a database
				DataTable dtReagentsInInvoice = BOL.Reagent.GetReagentsForInvoice(this.txtInvoiceNumber.Text.Trim());
				dtReagentsInInvoice.CaseSensitive = true;
				DataRow[] drExistingReagents = dtReagentsInInvoice.Select(VbecsTables.Reagent.LotNumber + " = '" + this.txtLotNumber.Text.Trim().Replace("'", "''") + "' AND " + Common.VbecsTables.ReagentType.ReagentTypeName + " = '" + this.cmbReagentType.Text.Trim() + "'");
				if (drExistingReagents.Length > 0)
				{
					string message = "You are trying to enter reagent that has already been logged into the system for this invoice. There have already been " + drExistingReagents[0][Common.VbecsTables.Reagent.NumberVialsAvailable].ToString() + " vials of this reagent type entered for this invoice. Do you need to enter more?";
					DialogResult saveResult = GuiMessenger.ShowMessageBox(StrRes.ConfMsg.Common.Dynamic(message));
					if (saveResult == DialogResult.Yes)
					{
						ClearReagentData(false);

						if (IsCurrentUserAuthorizedForFunction(FunctionCode.StandardAccess))
						{
							FrmUpdateReagentInventory _frmU = new FrmUpdateReagentInventory();
							_frmU.MdiParent = this.MdiParent;
							_frmU.Show();
							_frmU.SearchAndOpenNode(drExistingReagents[0][Common.VbecsTables.Reagent.LotNumber].ToString().Trim());
						}
						else
						{
							GuiMessenger.ShowMessageBox(StrRes.SysErrMsg.Common.InsufficientSecurityPrivileges("perform this function"));
						}
					}
					else
					{
						ClearReagentData(false);
					}
				}
				else
				{
					foreach (ListViewItem lv in this.lvInventory.Items)
					{
						DataRow drReagent = (DataRow)lv.Tag;
						if (drReagent[Common.VbecsTables.Reagent.LotNumber].ToString().Trim() == this.txtLotNumber.Text.Trim() &&
							drReagent[Common.VbecsTables.ReagentType.ReagentTypeName].ToString().Trim() == this.cmbReagentType.Text.Trim() &&
							drReagent[Common.VbecsTables.Reagent.InvoiceNumber].ToString().Trim() == this.txtInvoiceNumber.Text.Trim())
						{
							string message = "You are trying to enter reagent that has already been added for this invoice.";
							DialogResult saveResult = GuiMessenger.ShowMessageBox(StrRes.SysErrMsg.Common.Dynamic(message));
							ClearReagentData(false);
							break;
						}
					}
				}
			}
		}

		private void rdoSatisfactory_Click(object sender, System.EventArgs e)
		{
			_bValidInspection = true;
			this.txtComments.Text = string.Empty;
			this.txtComments.Enabled = false;
			this.cmbComment.SelectedIndex = -1;
			this.cmbComment.Text = "";
			this.cmbComment.Enabled = false;
			CheckForValidReagentData();
		}

		private void rdoUnsatisfactory_Click(object sender, System.EventArgs e)
		{
			_bValidInspection = false;
			this.cmbComment.Enabled = true;
			this.cmbComment.Focus();
			this.txtComments.Enabled = true;
			CheckForValidReagentData();
		}

		private void cmbComment_SelectedIndexChanged(object sender, System.EventArgs e)
		{
			if (this.cmbComment.Text.Trim() == "Other")
			{
				this.lblDetails.Text = "Details*";
				_bValidInspection = false;
			}
			else
			{
				this.lblDetails.Text = "Details";
				_bValidInspection = true;
			}
			CheckForValidReagentData();
		}

		private void txtComments_TextChanged(object sender, System.EventArgs e)
		{
			if (this.cmbComment.Text.Trim() == "Other")
			{
				_bValidInspection = txtComments.Text.Trim().Length > 0 && rdoUnsatisfactory.Checked && cmbComment.SelectedIndex != -1;
			}
			CheckForValidReagentData();
		}

		private void btnAdd_Click(object sender, System.EventArgs e)
		{
			DataRow drReagent;
			ListViewItem lvReagent;
            
            

			if (((System.Windows.Forms.Button)sender).Text == "&Add")
			{
                drReagent = this._dtLvReagents.Rows.Add();
				lvReagent = new ListViewItem();
			}
			else
			{
				lvReagent = this.lvInventory.Items[_nSelectedListViewItemIndex];
				drReagent = (DataRow)lvReagent.Tag;
				lvReagent.SubItems.Clear();
			}

			drReagent[Common.VbecsTables.Reagent.ReagentGuid] = System.Guid.NewGuid();

			foreach(DataRow drReagentType in _dtReagentTypes.Rows)
			{
				if (drReagentType[Common.VbecsTables.ReagentType.ReagentTypeName].ToString() == cmbReagentType.Text)
				{
					drReagent[Common.VbecsTables.ReagentType.ReagentTypeId] = drReagentType[Common.VbecsTables.ReagentType.ReagentTypeId];
				}
			}

			drReagent[Common.VbecsTables.Reagent.ReagentName] = this.cmbManufacturerReagentName.Text;
			drReagent[Common.VbecsTables.Reagent.ReceiptDate] = this.dtpReceivedDate.Value;
			drReagent[Common.VbecsTables.Reagent.ReceiptTechId] = ThisUser.UserNTLoginID;
			drReagent[Common.VbecsTables.Reagent.InvoiceNumber] = this.txtInvoiceNumber.Text;
			drReagent[Common.VbecsTables.Reagent.LotNumber] = this.txtLotNumber.Text;
			drReagent[Common.VbecsTables.Reagent.LotExpirationDate] = this.dtpExpirationDate.Value;
			drReagent[Common.VbecsTables.Reagent.NumberVialsReceived] = this.updVials.Value;
			drReagent[Common.VbecsTables.Reagent.NumberVialsAvailable] = this.updVials.Value;
			drReagent[Common.VbecsTables.Reagent.Comments] = this.cmbComment.Text.Trim() + " " + this.txtComments.Text.Trim();
			drReagent[Common.VbecsTables.Reagent.ReagentManufacturerName] = this.cmbManufacturer.Text;
			drReagent[Common.VbecsTables.ReagentType.ReagentTypeName] = this.cmbReagentType.Text;
			drReagent[Common.VbecsTables.Reagent.DivisionCode] = LogonUser.LogonUserDivisionCode;
			drReagent[Common.VbecsTables.Reagent.RecordStatusCode] = RecordStatusCode.Active;

			if(this.rdoSatisfactory.Checked == true)
			{
				drReagent[Common.VbecsTables.Reagent.InspectionIndicator] = true;
			}
			else
			{
				drReagent[Common.VbecsTables.Reagent.InspectionIndicator] = false;
			}

			lvReagent.SubItems.Add(drReagent[Common.VbecsTables.Reagent.ReagentName].ToString());
			lvReagent.SubItems.Add(drReagent[Common.VbecsTables.Reagent.LotNumber].ToString());
			lvReagent.SubItems.Add(VBECSDateTime.FormatDateString(drReagent[Common.VbecsTables.Reagent.LotExpirationDate]));
			lvReagent.SubItems.Add(drReagent[Common.VbecsTables.Reagent.NumberVialsReceived].ToString());
			lvReagent.SubItems.Add(drReagent[Common.VbecsTables.Reagent.InvoiceNumber].ToString());
			lvReagent.SubItems.Add(drReagent[Common.VbecsTables.Reagent.ReagentManufacturerName].ToString());
			lvReagent.SubItems.Add(drReagent[Common.VbecsTables.ReagentType.ReagentTypeName].ToString());
			if ((bool)drReagent[Common.VbecsTables.Reagent.InspectionIndicator] == true)
			{
				lvReagent.SubItems.Add("Satisfactory");
			}
			else
			{
				lvReagent.SubItems.Add("Unsatisfactory");
			}
		    
			lvReagent.Tag = drReagent;
			lvReagent.Checked = true;

			if (((System.Windows.Forms.Button)sender).Text == "&Add")
			{
				this.lvInventory.Items.Add(lvReagent);
			}
			//
			controls.VbecsFunction.SetColumnWidths(this.lvInventory);
			//

			this.UpdateManufacturerComboBoxes();

			ClearReagentData(false);
			this.lvInventory.SelectedItems.Clear();
			this.btnOK.EnabledButton = true;
			this.btnOK.SetToolTip("");
		}

		private void UpdateManufacturerComboBoxes()
		{
			//First do the Manufacturer combobox ----------------------------------------
			bool foundValue = false;

			foreach(string typeText in this.cmbManufacturer.Items)
			{
				if (typeText == this.cmbManufacturer.Text)
				{
					foundValue = true;
					break;
				}
			}
			
			if (!foundValue)
			{
				this.cmbManufacturer.Items.Add(this.cmbManufacturer.Text);
			}

			//Now do the Manufacturer Reagent Name combobox ------------------------------
			foundValue = false;
			foreach(string typeText in this.cmbManufacturerReagentName.Items)
			{
				if (typeText == this.cmbManufacturerReagentName.Text)
				{
					foundValue = true;
					break;
				}
			}
			
			if (!foundValue)
			{
				this.cmbManufacturerReagentName.Items.Add(this.cmbManufacturerReagentName.Text);
			}

		}

		private void btnClear_Click(object sender, System.EventArgs e)
		{
			ClearReagentData(false);
		}

		private void lvInventory_SelectedIndexChanged(object sender, System.EventArgs e)
		{
			if (this.lvInventory.SelectedItems.Count <= 0) return;

			_nSelectedListViewItemIndex = this.lvInventory.SelectedIndices[0];
			ListViewItem lvReagent = this.lvInventory.SelectedItems[0];
			DataRow drReagent = (DataRow)lvReagent.Tag;

			this.cmbManufacturerReagentName.Text = drReagent[Common.VbecsTables.Reagent.ReagentName].ToString();
			this.dtpReceivedDate.Value = (DateTime)drReagent[Common.VbecsTables.Reagent.ReceiptDate];
			this.txtInvoiceNumber.Text = drReagent[Common.VbecsTables.Reagent.InvoiceNumber].ToString();
			this.txtLotNumber.Text = drReagent[Common.VbecsTables.Reagent.LotNumber].ToString();
			this.dtpExpirationDate.Value = (DateTime)drReagent[Common.VbecsTables.Reagent.LotExpirationDate];
			this.updVials.Value = System.Convert.ToInt32(drReagent[Common.VbecsTables.Reagent.NumberVialsReceived]);
			this.cmbManufacturer.Text = drReagent[Common.VbecsTables.Reagent.ReagentManufacturerName].ToString();
			this.cmbReagentType.Text = drReagent[Common.VbecsTables.ReagentType.ReagentTypeName].ToString();
			this.txtComments.Text = drReagent[Common.VbecsTables.Reagent.Comments].ToString();
			
			if((bool)drReagent[Common.VbecsTables.Reagent.InspectionIndicator] == true)
			{
				this.rdoSatisfactory.Checked = true;
			}
			else
			{
				this.rdoUnsatisfactory.Checked = true;
			}

			_bValidReagentName = true;
			_bValidReagentType = true;
			_bValidLotNumber = true;
			_bValidExpirationDate = true;
			_bValidVials = true;
			_bValidTests = true;
			_bValidInspection = true;
			this.btnAdd.EnabledButton = true;
			this.btnAdd.SetToolTip("");
			this.btnAdd.Text = "&Update";

			this.cmbReagentType.Enabled = true;
			this.txtLotNumber.Enabled = true;
			this.dtpExpirationDate.Enabled = true;
			this.rdoSatisfactory.Enabled = true;
			this.rdoUnsatisfactory.Enabled = true;
			this.updVials.Enabled = true;
			//508 Compliance
			this.SpeakListViewWithCheckBox(lvInventory);
		}

		private void btnOK_Click(object sender, System.EventArgs e)
		{
		   System.Data.DataTable dtLVReagentClone = this._dtLvReagents.Clone();
           System.Data.DataRow drLVReagentRowClone;
           this.IsDirty = false;



			foreach(ListViewItem itmReagent in this.lvInventory.Items)
			{
			    if (itmReagent.Checked)
			    {
			        drLVReagentRowClone = dtLVReagentClone.NewRow();
			        drLVReagentRowClone.ItemArray = (object[]) ((DataRow) itmReagent.Tag).ItemArray.Clone();
			        dtLVReagentClone.Rows.Add(drLVReagentRowClone);
			    }
			}
		    if (dtLVReagentClone.Rows.Count > 0)
			{
				DialogResult saveResult = GuiMessenger.ShowMessageBox(StrRes.ConfMsg.Common.OKToSave("reagent invoice"));
			
				if (saveResult != DialogResult.Yes) return;

                if (BOL.Reagent.InsertNewReagent(dtLVReagentClone, _dtReagentTypes, UpdateFunction.UC020FrmLogInReagents))
				{
					this.DialogResult = DialogResult.OK;
					this.Close();
				}
				else
				{
					GuiMessenger.ShowMessageBox(StrRes.SysErrMsg.Common.DataNotSaved("Reagent invoice"));
				}
				//CR 1441
				System.Data.DataTable dt  = BOL.WorkloadEvent.GetWorkloadProcessGuidByProcessID((int) Common.WorkloadProcessID.LoginReagent);
				if(dt!= null)
				{
					if(dt.Rows.Count == 0)
					{
						GuiMessenger.ShowMessageBox(Common.StrRes.InfoMsg.UC015.BR1502_NoWorkloadDefined());
					}
				}
				
				
			}
			else
			{
				DialogResult saveResult = GuiMessenger.ShowMessageBox(StrRes.ConfMsg.UC020.NothingToSave());
			
				if (saveResult != DialogResult.Yes) 
					return;
				else
				{
					this.Close();
				}
			}
		}

		private void btnCancel_Click(object sender, System.EventArgs e)
		{
			this.DialogResult = DialogResult.Cancel;
			this.Close();
		}

		private void lvInventory_ColumnClick(object sender, System.Windows.Forms.ColumnClickEventArgs e)
		{
			if (e.Column == 3)
			{
				controls.ColumnClickSorter.ColumnClickHandler(sender, e, lvInventory.CheckBoxes, controls.ColumnClickSorter.ColumnSortType.DateTime);
			}
			else if (e.Column == 4 || e.Column == 5)
			{
				controls.ColumnClickSorter.ColumnClickHandler(sender, e, lvInventory.CheckBoxes, controls.ColumnClickSorter.ColumnSortType.Integer);
			}
			else 
			{
				controls.ColumnClickSorter.ColumnClickHandler(sender, e, lvInventory.CheckBoxes, controls.ColumnClickSorter.ColumnSortType.String);
			}

			if (this.lvInventory.SelectedItems.Count > 0)
			{
				_nSelectedListViewItemIndex = this.lvInventory.SelectedIndices[0];
			}
		}

		private void cmbManufacturerReagentName_TextChanged(object sender, System.EventArgs e)
		{
			if(cmbManufacturerReagentName.Text.Trim().Length == 0)
			{
				_bValidReagentName = false;
			}
			else
			{
				_bValidReagentName = true;
				this.cmbReagentType.Enabled = true;
				this.txtLotNumber.Enabled = true;
				this.dtpExpirationDate.Enabled = true;
				this.rdoSatisfactory.Enabled = true;
				this.rdoUnsatisfactory.Enabled = true;
				this.updVials.Enabled = true;
			}
			CheckForValidReagentData();
		}

		private void cmbManufacturer_TextChanged(object sender, System.EventArgs e)
		{
			if(cmbManufacturer.Text.Trim().Length == 0)
			{
				_bValidManufacturer = false;
			}
			else
			{
				_bValidManufacturer = true;
			}
		}

		/// <summary>
		/// **** 508 Compliance ***
		/// </summary>
		/// <param name="sender"></param>
		/// <param name="e"></param>
		private void FrmLogInReagents_KeyDownSpeakMessage(object sender, System.EventArgs e)
		{
			string textToSpeak = "";

			if (this.btnAdd.EnabledButton == false)
			{
				textToSpeak = this.btnAdd.GetToolTip();
			}
			else if (this.btnOK.EnabledButton == false)
			{
				textToSpeak = this.btnOK.GetToolTip();
			}

			this.SpeakMessage( textToSpeak );		
		}

		#endregion
	}

}

